;      :				      			       
;       - DS1307                                  
			                                                                           
;********************************************************************
 list	P=PIC16F628A 
 #include <P16F628A.INC>
 __CONFIG _BODEN_ON & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _CP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT
 errorlevel-302

 #define	_Z		    STATUS,Z
 #define	_C		    STATUS,C
 #define	bank_0		STATUS,RP0
 #define	bank_1		STATUS,RP0
			; DS1307
 #define    SCL     	PORTA,0     ; 
 #define    SDA     	PORTA,1     ;   SDA 
			; I2C
 #define    NACKM   	Flag,1      ;
 #define    ACK     	Flag,0      ;  

 #define    INT			PORTB,0		;     INT
 #define	Knop        PORTA,5
 #define	Nagrev    	PORTA,4

 #define	RC_Minut    PORTA,7
 #define	RC_Chas  	PORTA,6
			;lcd
 #define	D4			PORTB,4 
 #define	D5		    PORTB,5
 #define	D6		    PORTB,6
 #define    D7		    PORTB,7
 #define	RS		    PORTA,3
 #define	E		    PORTA,2			 
;;
 cblock	0x20
Reg_1
Reg_2
Reg_3
Count_I2C
Count
Tochki
Reg_TX  	;    
Reg_RX   	;      slave
Flag   	    ;  
				; 0 - Flag ACK:   0 -   1 -  
				; 1 - Flag NACKM: 0 -   1 -  
				; 2 - Flag,2	  0 -  , 1 -  
				; 3 -      
R_Min			;   
R_Chas			;   
Minut,D_Minut,Chas,D_Chas
Temp
temp_Min,temp_D_Min,temp_Chas,temp_D_Chas
N_Min_Bkl,N_D_Min_Bkl,N_Chas_Bkl,N_D_Chas_Bkl             
N_Min_Bykl,N_D_Min_Bykl,N_Chas_Bykl,N_D_Chas_Bykl
Sravnen_Bkl,Sravnen_Bykl
Data_EEPR
load_data_LCD	;     
Data_EEprom		;    EEPROM
    endc
;
    		ORG     0x00       
      		goto    START           	
    		ORG     0x04		;  
    		  RETFIE            ;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;		
START
			clrf	INTCON
    		bsf	    bank_1		    ; bank 1
    		movlw	b'11000000'		; 7 - 1 =   
    		movwf	OPTION_REG		; 6 - 1 =  INT    
    		movlw	b'00100000'		
    		movwf	TRISA
    		movlw	b'00000001'
    		movwf	TRISB
    		bcf	    bank_0		    ; bank 0
			movlw	7
			movwf	CMCON			;  
			clrf	PORTA
			clrf	PORTB
;        22h  55h
            movlw   0x21
            movwf   FSR
Load_ad		clrf    INDF
            incf    FSR,f
            movlw   0x45
            subwf   FSR,w
            btfss   _Z
            goto    Load_ad

            bsf     Nagrev          ;
; goto	z
;;
;-------------------------------------------;
; 
			Call	Init_LCD
			Call	Nadpisi
			Goto	Init_1307
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-------------------------------------------;
Nadpisi;     Time
            movlw       0x80            ;     
			call        Load_command
			movlw	    'T' 	        ;  
			call        Load_symbol		; Load - , symbol- .
			movlw	    'i'
			call        Load_symbol
			movlw	    'm'
			call        Load_symbol
			movlw	    'e'
			call        Load_symbol    		    
;    
ON          movlw       0xC0            ;     
			call        Load_command
			movlw	    'O' 	        ;  
			call        Load_symbol		; Load - , symbol- .
            movlw       'n'
			call        Load_symbol
;
OFF      	movlw	    0xC8	        ;     
			call        Load_command    ;    -   
			movlw       'O'             ;  
			call        Load_symbol
            movlw       'f'
			call        Load_symbol	
            movlw       'f'
			call        Load_symbol		
			movlw	    ' '
			call        Load_symbol
				RETURN
;fffffffffffffffffffffffffffffffffffffff;
;---------------------------------------;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;  DS1307 
Init_1307
			movlw	7			;   
			movwf	Count		;  1307
			call	Start	    ; 
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;  
			call	TX		    ; 
            btfsc   ACK         ;     
            goto    Init_1307   ;   - 
			;-------------------;
			movlw	b'00000000'	;    
			movwf	Reg_TX 	    ;   
			call	TX		    ;   
            btfsc   ACK         ;    
            goto    Init_1307   ;   ,  
			;-------------------;
aaa			movlw	0			;    7 
			movwf	Reg_TX 	    ;
			call	TX		    ; 
            btfsc   ACK         ;    
            goto    Init_1307   ;   ,  
			decfsz	Count,f		; 
			goto	aaa

;-------------------------------;
			movlw	b'00010000' ;    
			movwf	Reg_TX 	    ;   Out   1.
			call	TX		    ;  - 0x07
            btfsc   ACK         ;    
            goto    Init_1307   ;   ,  
			call	Stop	    ;
;;
;-------------------------------;
;;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-------------------------------------------------------------------------;
MAIN	
			btfss	Knop
			Goto	Setting

			Call	Read_time
			Call	Sravnenie
			Call	Ind_Time
			Call	Ind_Time_Bkl
			Call	Ind_Time_Bykl
Cycle
			btfss	INTCON,1	;       
			goto	$-1			;    RB0/INT   
			nop					;     
			nop					;      
 			nop					;        GIE (INTCON<7>).
			bcf		INTCON,1
			;-------------------;
			Goto	MAIN
;--------------------------------------------------------------------------;
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-----------------------------------------------------------------------------------;   
;        "RC_in_Bin"
;         
Setting
			Call	MS25		; 
			btfss	Knop		;    
			Goto	$-1
			clrf	Minut
			clrf	D_Minut
			clrf	Chas
			clrf	D_Chas
			bsf		Flag,3
		   ;; 
            movlw   1	    	;  
			call    Load_command; 
 			Call	mS_5
            movlw   0x80    	;    
			call    Load_command;
			;-------------------;
			movlw	Bkl-0x2100	;     EEPROM
			bsf		bank_1		;
			movwf	EEADR		;     
Cykle_1	   	bsf		bank_1 		;
			bsf     EECON1,0  	;  ( )			
			incf	EEADR,f   	; 
     	    movfw   EEDATA		; .    EEPROM   W.	
    		bcf     bank_0		;
			btfsc	_Z			;     ( )
			Goto	Main_Bkl	;
			call    Load_symbol	;>>    
			Goto	Cykle_1		;
		   ;; 
Main_Bkl   
		 	call    MS25
		   ;--------------------;
  			Call	Ind_Time_Bkl
		   ;--------------------;
    		clrf    N_D_Min_Bkl
    		clrf    N_Min_Bkl
    		bsf	 	bank_1
    		bsf     RC_Minut		;  
    		bcf     bank_0
;     59		    
;-----------------------------------;
N1		
			btfss   RC_Minut		;    "1" ?
    		goto    Fin1			;  "0"
    		incf    N_Min_Bkl,f    ;  
    		movfw   N_Min_Bkl		;   
    		addlw   -.9			; 
    		btfss   _Z      		;   "9"?
    		goto    n1				; ,  
    		movfw   N_D_Min_Bkl	;  "9",   
    		addlw   -.5			;   "59" ?
    		btfss   _Z      
    		goto    N1				; ,      
    		goto    Fin1			;   59 -  .
n1    		movfw   N_Min_Bkl		;    "10" 
    		addlw   -.10			;    "10"
    		btfss   _Z      		; 
    		goto    N1				;   
            clrf    N_Min_Bkl		;  "10"     
    		incf    N_D_Min_Bkl,f  ;    "1"   
    		goto    N1				;    
			    
Fin1	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut
			movfw	N_Min_Bkl		;     
			movwf	Minut			;  
			movfw	N_D_Min_Bkl		; N_Min_Bkl  N_D_Min_Bkl
			movwf	D_Minut			;  Minut   D_Minut  
;     
    		clrf    N_D_Chas_Bkl
    		clrf    N_Chas_Bkl
    		bsf	 	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N2		    btfss   RC_Chas
    		goto    Fin2
    		incf    N_Chas_Bkl,f        ;
    		movfw   N_Chas_Bkl
    		addlw   -.3
    		btfss   _Z      
    		goto    n2
    		movfw   N_D_Chas_Bkl
    		addlw   -.2
    		btfss   _Z      
    		goto    N2
    		goto    Fin2
n2    		movfw   N_Chas_Bkl
    		addlw   -.10
    		btfss   _Z      
    		goto    N2
            clrf    N_Chas_Bkl
    		incf    N_D_Chas_Bkl,f        ;
    		goto    N2
    
Fin2	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf		RC_Chas

			movfw	N_Chas_Bkl		;     
			movwf	Chas			;  
			movfw	N_D_Chas_Bkl	; N_Min_Bkl  N_D_Min_Bkl
			movwf	D_Chas			;

            btfsc   Knop
            goto    Main_Bkl 
            btfss   Knop 
            goto    $-1       
            goto    Time_Bykl
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;  
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;    
Time_Bykl;   
            call    MS25
		   ;; 
            movlw   1	    	;  
			call    Load_command;
 			Call	mS_5
            movlw   0x80    	;    
			call    Load_command;
			movlw	Bykl-0x2100 ;     EEPROM
			bsf		bank_1		;
			movwf	EEADR		;     
Cykle_2	   	bsf		bank_1 		;
			bsf     EECON1,0  	;  ( )			
			incf	EEADR,f   	; 
     	    movfw   EEDATA		; .    EEPROM   W.	
    		bcf     bank_0		;
			btfsc	_Z			;     ( )
			Goto	Main_Bykl	;
			call    Load_symbol	;]]    
			Goto	Cykle_2
		   ;;
Main_Bykl   call    MS25       		
			Call	Ind_Time_Bykl 
            clrf    N_D_Min_Bykl
    		clrf    N_Min_Bykl
    		bsf	 	bank_1
    		bsf     RC_Minut
    		bcf     bank_0

N3		    btfss   RC_Minut
    		goto    Fin3
    		incf    N_Min_Bykl,f        ;
    		movfw   N_Min_Bykl
    		addlw   -.9
    		btfss   _Z      
    		goto    n3
    		movfw   N_D_Min_Bykl
    		addlw   -.5
    		btfss   _Z      
    		goto    N3
    		goto    Fin3
n3    		movfw   N_Min_Bykl
    		addlw   -.10
    		btfss   _Z      
    		goto	N3
            clrf    N_Min_Bykl
    		incf    N_D_Min_Bykl,f        ;
    		goto    N3
    
Fin3	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut

			movfw	N_Min_Bykl		;     
			movwf	Minut			;  
			movfw	N_D_Min_Bykl	; N_Min_Bykl  N_D_Min_Bykl
			movwf	D_Minut			;  Minut   D_Minut  
  
;sssssssssssssssssssssssssssssssss;
;     
    		clrf    N_D_Chas_Bykl
    		clrf    N_Chas_Bykl
    		bsf	  	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N4		    btfss   RC_Chas
    		goto    Fin4
    		incf    N_Chas_Bykl,f        ;
    		movfw   N_Chas_Bykl
    		addlw   -.3
    		btfss   _Z      
    		goto    n4
    		movfw   N_D_Chas_Bykl
    		addlw   -.2
    		btfss   _Z      
    		goto    N4
    		goto    Fin4
n4    		movfw   N_Chas_Bykl
    		addlw   -.10
    		btfss   _Z      
    		goto    N4
            clrf    N_Chas_Bykl
    		incf    N_D_Chas_Bykl,f        ;
    		goto    N4
    
Fin4	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf     RC_Chas

			movfw	N_Chas_Bykl		;     
			movwf	Chas			;  
			movfw	N_D_Chas_Bykl	; N_Min_Bykl  N_D_Min_Bykl
			movwf	D_Chas	

            btfsc   Knop
            goto    Main_Bykl
            btfss   Knop 
            goto    $-1   
            goto    Time_real
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-----------------------------------;
;           
			; 
Time_real
		    call    MS25 
            movlw   1	    	;  
			call    Load_command;
  			Call	mS_5
            movlw   0xC0    	;    
			call    Load_command;
			movlw	Time-0x2100	;     EEPROM
			bsf		bank_1		; " Set Real Time  "
			movwf	EEADR		;     
Cykle_3	   	bsf		bank_1 		;
			bsf     EECON1,0  	;  ( )			
			incf	EEADR,f   	; 
     	    movfw   EEDATA		; .    EEPROM   W.	
    		bcf     bank_0		;
			btfsc	_Z			;     ( )
			Goto	Main_Time	;
			call    Load_symbol	;>>    
			Goto	Cykle_3		;
Main_Time
            call    MS25           
			Call	Ind_Time       
            clrf    D_Minut
    		clrf    Minut
    		bsf		bank_1
    		bsf     RC_Minut
    		bcf     bank_0

N		    btfss   RC_Minut
    		goto    Fin
    		incf    Minut,f        ;
    		movfw   Minut
    		addlw   -.9
    		btfss   _Z      
    		goto    n
    		movfw   D_Minut
    		addlw   -.5
    		btfss   _Z      
    		goto    N
    		goto    Fin
n    		movfw   Minut
    		addlw   -.10
    		btfss   _Z      
    		goto    N
            clrf    Minut
    		incf    D_Minut,f        ;
    		goto    N
    
Fin 	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut
;fffffffffffffffffffffffffffffffff;
;sssssssssssssssssssssssssssssssss;
;             
    		clrf    D_Chas
    		clrf    Chas
    		bsf	 	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N0		    btfss   RC_Chas
    		goto    Fin0
    		incf    Chas,f        ;
    		movfw   Chas
    		addlw   -.3
    		btfss   _Z      
    		goto    n0
    		movfw   D_Chas
    		addlw   -.2
    		btfss   _Z      
    		goto    N0
    		goto    Fin0
n0    		movfw   Chas
    		addlw   -.10
    		btfss   _Z      
    		goto    N0
            clrf    Chas
    		incf    D_Chas,f        ;
    		goto    N0
    
Fin0	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf     RC_Chas

            btfsc   Knop
            goto    Main_Time 
            btfss   Knop 
            goto    $-1        
            Call    Write_Time		;   
			Call	Nadpisi
			bcf		Flag,3	
			Goto	MAIN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;    
Ind_Time
            movlw   0x86            ;     
			call    Load_command

            movfw   D_Chas		;     
            btfss   _Z			;   "0"
            goto    $+4         ; 
            movlw   20h			;   (  )
			call    Load_symbol	;
            goto    M
            movlw   30h
            addwf   D_Chas,w
			call    Load_symbol
M           movlw   30h
            addwf   Chas,w
			call    Load_symbol
;----------------------------------;
;            
			incf	Tochki,f
            btfsc   Tochki,0   
            movlw   ':'
            btfss   Tochki,0         
            movlw   20h
			call    Load_symbol
;---------------------------------;
            movlw   30h
            addwf   D_Minut,w
			call    Load_symbol
            movlw   30h
            addwf   Minut,w
			call    Load_symbol 
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;     
Ind_Time_Bkl
			btfsc	Flag,3
            movlw   0xc5    		;			
			btfss	Flag,3
            movlw   0xc2    		; 
			call    Load_command
			;-----------------------;
            movfw   N_D_Chas_Bkl	;     
            btfss   _Z				;   "0"
            goto    $+4         	; 
            movlw   20h				;   (  )
			call    Load_symbol		;
            goto    M1
            movlw   30h
            addwf   N_D_Chas_Bkl,w
			call    Load_symbol
M1          movlw   30h
            addwf   N_Chas_Bkl,w
			call    Load_symbol
			;-----------------------; 
            movlw   ':'
			call    Load_symbol
			;-----------------------;
            movlw   30h				;
            addwf   N_D_Min_Bkl,w
			call    Load_symbol
            movlw   30h
            addwf   N_Min_Bkl,w
			call    Load_symbol
			movlw	' '				;   
			call    Load_symbol		;  		 
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
Ind_Time_Bykl
			btfsc	Flag,3
            movlw   0xc5    	;			
			btfss	Flag,3
            movlw   0xcb    	; 
			call    Load_command
            movfw   N_D_Chas_Bykl;     
            btfss   _Z			;   "0"
            goto    $+4         ; 
            movlw   20h			;   (  )
			call    Load_symbol	;
            goto    M2
            movlw   30h
            addwf   N_D_Chas_Bykl,w
			call    Load_symbol
M2          movlw   30h
            addwf   N_Chas_Bykl,w
			call    Load_symbol
;-------------------------------; 
            movlw   ':'
			call    Load_symbol
;-------------------------------;
            movlw   30h
            addwf   N_D_Min_Bykl,w
			call    Load_symbol
            movlw   30h
            addwf   N_Min_Bykl,w
			call    Load_symbol 
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;; 
;-----------------------------------;
Write_Time
			swapf	D_Minut,w
			iorwf	Minut,f
			swapf	D_Chas,w
			iorwf	Chas,f

        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			call	Start  
			call	TX		    ; 
            btfsc   ACK         ;    1307 
            goto    Write_Time  ;   - 

        	movlw   0x01		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Write_Time  ;   - 

			call	Start   	;  
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Write_Time  ;   - 
 
        	movfw	Minut		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Write_Time  ;   - 

        	movfw	Chas		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Write_Time  ;   - 
				RETURN
;-------------------------------;
;;
;-------------------------------;
Read_time
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			call	Start  
			call	TX		    ; 
            btfsc   ACK         ;    1307 
            goto    Read_time   ;   - 

        	movlw   0x01		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Read_time   ;   - 

			call	Start   	;  
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			bsf		Reg_TX,0	;
			call	TX		    ;
		    bcf     NACKM  		;   

            call    RX          ;   
            movfw   Reg_RX      ;    
            movwf   R_Min       ;      
            bsf     NACKM		;   
            call    RX	  		; 
            movfw   Reg_RX      ;   
            movwf   R_Chas      ;   
			call	Stop	    ;   
;-------------------------------;
Transform
;-------------------------------;			
            movfw   R_Min       ;
            andlw   0fh		    ;           
            movwf   Minut       ;  
            swapf   R_Min,w     ;
            andlw   0fh		    ;           
            movwf   D_Minut     ;  
            movfw   R_Chas      ;
            andlw   0fh		    ;           
            movwf   Chas        ; 
            swapf   R_Chas,w    ;
            andlw   0fh		    ;           
            movwf   D_Chas      ;  
				RETURN
;-------------------------------;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;      
Sravnenie							;   
            movfw   Minut            
            movwf   temp_Min    	
            movfw   D_Minut
            movwf   temp_D_Min
            movfw   Chas
            movwf   temp_Chas
            movfw   D_Chas
            movwf   temp_D_Chas
			;----------------------;	
            movfw   N_Min_Bkl 	   ;      
            subwf   temp_Min,f     ; .  0-  
 
            movfw   N_D_Min_Bkl    ;  1-  
            btfss   _C 
            incfsz  N_D_Min_Bkl,w 
            subwf   temp_D_Min,f 
 
            movfw   N_Chas_Bkl     ;  2-  
            btfss   _C 
            incfsz  N_Chas_Bkl,w 
            subwf   temp_Chas,f 
 
            movfw   N_D_Chas_Bkl    ;  3-  
            btfss   _C 
            incfsz  N_D_Chas_Bkl,w 
            subwf   temp_D_Chas,f

            btfss   _C              ;    ="0",   
            	RETURN          	;    
			;  
Vykl    
            movfw   Minut            
            movwf   temp_Min    	;   
            movfw   D_Minut
            movwf   temp_D_Min
            movfw   Chas
            movwf   temp_Chas
            movfw   D_Chas
            movwf   temp_D_Chas
			;-----------------------;
            movfw   N_Min_Bykl      ;     
            subwf   temp_Min,f 		;  .  0-  
 
            movfw   N_D_Min_Bykl	;  1-  
            btfss   _C 
            incfsz  N_D_Min_Bykl,w 
            subwf   temp_D_Min,f 
 
            movfw   N_Chas_Bykl     ;  2-  
            btfss   _C 
            incfsz  N_Chas_Bykl,w 
            subwf   temp_Chas,f 
 
            movfw   N_D_Chas_Bykl   ;  3-  
            btfss   _C 
            incfsz  N_D_Chas_Bykl,w 
            subwf   temp_D_Chas,f
			;-----------------------;
            btfss   _C		;    ="0",   
							;    
            bcf     Nagrev  ;  ,     
							;  
			btfsc	_C
            bsf     Nagrev  ;  ,     
							;  
		    	RETURN
;-----------------------------------;
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII;
;-----------------------------------;  	   
;;
;-------------------------------;
MS25        movlw       .118    ;
            movwf       Reg_1   ; 
            movlw       .33     ;
            movwf       Reg_2   ;
            decfsz      Reg_1,F ;
            goto        $-1     ;
            nop                 ;
            decfsz      Reg_2,F ;
            goto        $-3     ;
                RETURN
;-------------------------------;
MKS10		
			movlw   .3
            movwf   Reg_1
            decfsz  Reg_1,F
            goto    $-1
			    RETURN
;--------------------------------;
;      EEPROM   ;
Read_EEPROM	
 			bsf     bank_1		;   1 .           
            movwf   EEADR    	;  02h   W   EEAdr.       
            bsf     EECON1,0  	;  ( )			
            movfw   EEDATA		; .    EEPROM   02h   W.
			bcf		bank_0			
				RETURN
;;
;;
	include		"I2C_connection.asm"
	include		"LCD_connection.asm"
;-----------------------------------------------------------------------;
        ORG 0x2100
Bkl		de	"  Set Time On   ",0	;  DE
Bykl	de	"  Set Time Off  ",0	; "0" -  
Time	de	"  Set Real Time ",0	; 
;;
	END

