;      :				      			       
;       - DS1307                                  
			                                                                           
;********************************************************************
 list p=16F676
 #include<P16F676.inc>
 __CONFIG _CPD_OFF & _CP_OFF & _BODEN & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT

 errorlevel-302

 #define	_Z		    STATUS,Z
 #define	_C		    STATUS,C
 #define	bank_0		STATUS,RP0
 #define	bank_1		STATUS,RP0
			; DS1307
 #define    SCL     	PORTC,2     ; 
 #define    SDA     	PORTC,1     ;   SDA 
			; I2C
 #define    NACKM   	Flag,1      ;
 #define    ACK     	Flag,0      ;  

 #define	Knop        PORTA,1
 #define	Svet    	PORTC,5
 #define	R_Foto      PORTA,3
 #define	RC_Minut    PORTC,3
 #define	RC_Chas  	PORTC,4
			;lcd
 #define	D4			PORTA,1 
 #define	D5		    PORTA,0
 #define	D6		    PORTA,2
 #define    D7		    PORTC,0
 #define	RS		    PORTA,5
 #define	E		    PORTA,4			 
;;
Knop_In		macro
		bsf		bank_1
		bsf		TRISA,1			;  
		bcf		bank_0
		endm
;-------------------------------;
Knop_Out	macro
		bsf		bank_1
		bcf		TRISA,1			;  
		bcf		bank_0
		endm
;-------------------------------;
 cblock	0x23
Reg_1
Reg_2
Reg_3
Count_I2C
Count
Tochki
Reg_TX  	;    
Reg_RX   	;      slave
Flag   	    ;  
				; 0 - Flag ACK:   0 -   1 -  
				; 1 - Flag NACKM: 0 -   1 -  
				; 2 - Flag,2	  0 -  , 1 -  
				; 3 -      
R_Sek
R_Min			;   
R_Chas			;   
Sekund,D_Sekund,Minut,D_Minut,Chas,D_Chas
Temp
Bin_L
temp_Min,temp_D_Min,temp_Chas,temp_D_Chas

N_D_Chas_Bkl,N_Chas_Bkl,N_D_Min_Bkl,N_Min_Bkl,N_D_Chas_Bykl,N_Chas_Bykl,N_D_Min_Bykl,N_Min_Bykl

Sravnen_Bkl,Sravnen_Bykl
Digit_H,Digit_M,Digit_L
Data_EEPR
load_data_LCD	;     
    endc
;
    		ORG     0x00       
      		goto    START           	
    		ORG     0x04		;  
    		  RETFIE            ;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS; 851		
START
			clrf	INTCON
            call    0x3FF	        ;   
			bsf  	bank_1			;    1
            movwf   OSCCAL	        ;   
            clrf    WPUA            ; .     
            bsf	    WPUA,1          ; . q     
            movlw   b'10000000'     ;
            movwf   OPTION_REG      ;      
			movlw 	0			    ;
			movwf 	TRISA 			;  PORTA - 
			movwf 	TRISC 			;     
            clrf    ANSEL           ;   
			bcf		bank_0	    	;  0
            movlw	.7              ;
            movwf	CMCON           ;  .
			clrf	PORTA
			clrf	PORTC
;        22h  55h
            movlw   0x21
            movwf   FSR
Load_ad		clrf    INDF
            incf    FSR,f
            movlw   0x49
            subwf   FSR,w
            btfss   _Z
            goto    Load_ad
            bcf     Svet      

;	goto	z
;;
; 
			Call	Init_LCD
			Call	Nadpisi	
;sssssssssssssssssssssssssssssssssssssssssss;
;      -  
;        -----;
i           movlw	0xd0     	    ;    0x80
			movwf	Reg_TX      	;    (R/W = 0)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    i               ; 
;      ;
            movlw	0       	    ;    0x01
			movwf	Reg_TX      	;    
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    i               ;   ,  

;          ;
ii          movlw	0xd0    	    ;    0x80
			movwf	Reg_TX      	;    
            bsf     Reg_TX,0        ; (R/W = 1)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    ii              ; 
;-----------------------------------;
            bsf     NACKM
            call    RX
			call	Stop	        ;   
			btfsc	Reg_RX,7		;   ?
			Call	Init_1307		;  			
;fffffffffffffffffffffffffffffffffffffffffff;
;     
Vostan      movlw   N_D_Chas_Bkl
            movwf   FSR
			movlw	Bkl_Bykl-0x2100	;    Bkl_Bykl,  
			bsf     bank_1      	;   .             
            movwf   EEADR       	;      
Loop_1		bsf     bank_1      	;
            bsf     EECON1,0    	;  ( )			
            movfw   EEDATA      	; 
			incf	EEADR,f 
			bcf		bank_0		
			movwf   INDF
            incf    FSR,f
            movlw   N_Min_Bykl+1	;     
            subwf   FSR,w
            btfss   _Z
            goto    Loop_1			
			Goto	MAIN
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-------------------------------------------;
Nadpisi;     Time
            movlw   0x80            	;     
			call    Load_command
			movlw	Time-0x2100			;     EEPROM
			Call	Text_EEPR			;  "Time           "
;    
ON          movlw   0xC0                ;     
			call    Load_command
			movlw	On_Off-0x2100		;     EEPROM
			Call	Text_EEPR			;  "On      Off     "
				RETURN
;fffffffffffffffffffffffffffffffffffffff;
;---------------------------------------;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;  DS1307 
Init_1307	
			movlw	7			;   
			movwf	Count		;  1307
			call	Start	    ; 
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;  
			call	TX		    ; 
            btfsc   ACK         ;     
            goto    Init_1307   ;   - 
			;-------------------;
			movlw	0x00		;    
			movwf	Reg_TX 	    ;   
			call	TX		    ;   
            btfsc   ACK         ;    
            goto    Init_1307   ;   ,  
			;-------------------;
aaa			movlw	0
			movwf	Reg_TX		;    7  	    
			call	TX		    ; 
            btfsc   ACK         ;    
            goto    Init_1307   ;   ,  
			decfsz	Count,f		; 
			goto	aaa			;
		    ;-------------------;
			movlw	b'00010011' ;    
			movwf	Reg_TX 	    ;   Out   1.
			call	TX		    ;  - 0x07
            btfsc   ACK         ;    
            goto    Init_1307	;   ,  
			call	Stop	    ;
				RETURN
;;
;-------------------------------;
;;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-------------------------------------------------------------------------;
MAIN
			Knop_In				;
			btfss	Knop
			Goto	Setting	
			Call	mS_500
			Knop_Out

 			Call	Read_time
			Call	Sravnenie
			Call	Ind_Time
			Call	Ind_Time_Bkl
			Call	Ind_Time_Bykl
	
			Goto	MAIN
;-------------------------------------------------------------------------;
;;
;;
;-------------------------------;   
;        "RC_in_Bin"
;         
;---------------------------------------;
Setting			  	
			btfss	Knop		;   "0",  
            goto    $-1			; 
			Knop_Out
			Call	Clean_1_Line;	
			movlw	Set_-0x2100	;     EEPROM
			Call	Text_EEPR	;  "  Setting   "
			Knop_In				;
			btfsc	Knop		;  
			Goto	$-1			;
;-------------------------------; 
			Knop_Out			;
 			bsf		Flag,3		; 
			Call	Clean_1_Line;	
			;-------------------;
			movlw	Bkl-0x2100	;     EEPROM
			Call	Text_EEPR	;  "  Set Time On   "
			Knop_In				;
;;
          	bsf     Reg_1,7		; 
            bsf     Reg_2,7		;  
            bsf		Reg_3,3
            ;-------------;
Dvk         decfsz  Reg_1,f
            goto    $-1
            decfsz  Reg_2,f     ; 
            goto    $-3
            btfsc   Knop        ;  
            Goto    Main_Bkl	;   -   Vk_Vyk
            decfsz  Reg_3,f
            goto    Dvk
			Goto	Time_Bykl	; ==> --> Time_Bykl
;-------------------------------;
Main_Bkl	Call	Ind_Time_Bkl
		   ;--------------------;
    		clrf    N_D_Min_Bkl
    		clrf    N_Min_Bkl
    		bsf	 	bank_1
    		bsf     RC_Minut		;  
    		bcf     bank_0
;     59		    
;-----------------------------------;
N1		
			btfss   RC_Minut		;    "1" ?
    		goto    Fin1			;  "0"
    		incf    N_Min_Bkl,f    	;  
    		movfw   N_Min_Bkl		;   
    		addlw   -.9				; 
    		btfss   _Z      		;   "9"?
    		goto    n1				; ,  
    		movfw   N_D_Min_Bkl		;  "9",   
    		addlw   -.5				;   "59" ?
    		btfss   _Z      
    		goto    N1				; ,      
    		goto    Fin1			;   59 -  .
n1    		movfw   N_Min_Bkl		;    "10" 
    		addlw   -.10			;    "10"
    		btfss   _Z      		; 
    		goto    N1				;   
            clrf    N_Min_Bkl		;  "10"     
    		incf    N_D_Min_Bkl,f  	;    "1"   
    		goto    N1				;    
			    
Fin1	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut		;  "1"   RC_Minut

			movfw	N_Min_Bkl		;     
			movwf	Data_EEPR
            movlw   0x03
            call    Load_EEPROM
			movfw	N_D_Min_Bkl		; N_Min_Bkl  N_D_Min_Bkl
			movwf	Data_EEPR
            movlw   0x02
            call    Load_EEPROM
;     
    		clrf    N_D_Chas_Bkl
    		clrf    N_Chas_Bkl
    		bsf	 	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N2		    btfss   RC_Chas
    		goto    Fin2
    		incf    N_Chas_Bkl,f        ;
    		movfw   N_Chas_Bkl
    		addlw   -.3
    		btfss   _Z      
    		goto    n2
    		movfw   N_D_Chas_Bkl
    		addlw   -.2
    		btfss   _Z      
    		goto    N2
    		goto    Fin2
n2    		movfw   N_Chas_Bkl
    		addlw   -.10
    		btfss   _Z      
    		goto    N2
            clrf    N_Chas_Bkl
    		incf    N_D_Chas_Bkl,f        ;
    		goto    N2
    
Fin2	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf		RC_Chas

			movfw	N_Chas_Bkl		;     
			movwf	Data_EEPR
            movlw   0x01
            call    Load_EEPROM
			movfw	N_D_Chas_Bkl	; N_Min_Bkl  N_D_Min_Bkl
			movwf	Data_EEPR
            movlw   0x00
            call    Load_EEPROM
		   ;-------------------;
			Knop_In
            btfss   Knop                 
            Goto    Cr 
  			Knop_Out 			
			Goto    Main_Bkl 
;-----------------------------------;
Cr          comf    Reg_1,f			;  
            bsf     Reg_2,4
            bsf		Reg_3,3
            ;-------------;
            decfsz  Reg_1,F
            goto    $-1
            decfsz  Reg_2,F     	; 
            goto    $-3
            btfsc   Knop        	;  
            Goto    Time_Bykl 		;   -   Time_real
            decfsz  Reg_3,F
            goto    $-7
;-----------------------------------;
			Call	OUT_Set			;  Out 
			Goto	MAIN			;   
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF; 
Clean_1_Line 						; 				
		    movlw   1	    		;  	
			call    Load_command	;				
			Call	mS_5			;				
            movlw   0x80    		;  	
			call    Load_command	;  			
				RETURN				;				
;-----------------------------------;---------------
OUT_Set								;				
 			Knop_Out				;				
			bcf		Flag,3			;               
			Call	Clean_1_Line	;				
			movlw	OUT-0x2100 		; 				
			Call	Text_EEPR		;  "OUT" 
			Knop_In					;				
			btfss	Knop			;				
			Goto	$-1				;						
			Knop_Out				;				
			Call	Nadpisi			;				
				RETURN				;				
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;    
Time_Bykl   ; 
			Knop_Out
			Call	Clean_1_Line
			movlw	Bykl-0x2100 ;     EEPROM
			Call	Text_EEPR	;  Set Time Off
			Knop_In				;
;;
          	bsf     Reg_1,7		; 
            bsf     Reg_2,7		;  
            bsf		Reg_3,3
            ;-------------;
Dvyk        decfsz  Reg_1,f
            goto    $-1
            decfsz  Reg_2,f     ; 
            goto    $-3
            btfsc   Knop        ;  
            Goto    Main_Bykl	;   -   Vk_Vyk
            decfsz  Reg_3,f
            goto    Dvyk
			Goto	Time_real
;-------------------------------;
Main_Bykl         		
			Call	Ind_Time_Bykl 
            clrf    N_D_Min_Bykl
    		clrf    N_Min_Bykl
    		bsf	 	bank_1
    		bsf     RC_Minut
    		bcf     bank_0

N3		    btfss   RC_Minut
    		goto    Fin3
    		incf    N_Min_Bykl,f        ;
    		movfw   N_Min_Bykl
    		addlw   -.9
    		btfss   _Z      
    		goto    n3
    		movfw   N_D_Min_Bykl
    		addlw   -.5
    		btfss   _Z      
    		goto    N3
    		goto    Fin3
n3    		movfw   N_Min_Bykl
    		addlw   -.10
    		btfss   _Z      
    		goto	N3
            clrf    N_Min_Bykl
    		incf    N_D_Min_Bykl,f        ;
    		goto    N3
    
Fin3	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut

			movfw	N_Min_Bykl		;     
			movwf	Data_EEPR
            movlw   0x07
            call    Load_EEPROM
			movfw	N_D_Min_Bykl	; N_Min_Bykl  N_D_Min_Bykl
  			movwf	Data_EEPR
            movlw   0x06
            call    Load_EEPROM
;sssssssssssssssssssssssssssssssss;
;     
    		clrf    N_D_Chas_Bykl
    		clrf    N_Chas_Bykl
    		bsf	  	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N4		    btfss   RC_Chas
    		goto    Fin4
    		incf    N_Chas_Bykl,f        ;
    		movfw   N_Chas_Bykl
    		addlw   -.3
    		btfss   _Z      
    		goto    n4
    		movfw   N_D_Chas_Bykl
    		addlw   -.2
    		btfss   _Z      
    		goto    N4
    		goto    Fin4
n4    		movfw   N_Chas_Bykl
    		addlw   -.10
    		btfss   _Z      
    		goto    N4
            clrf    N_Chas_Bykl
    		incf    N_D_Chas_Bykl,f        ;
    		goto    N4
    
Fin4	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf     RC_Chas

			movfw	N_Chas_Bykl		;     
			movwf	Data_EEPR
            movlw   0x05
            call    Load_EEPROM		;
			movfw	N_D_Chas_Bykl	; 
			movwf	Data_EEPR		;
            movlw   0x04			;
            call    Load_EEPROM		;
			;-----------------------;
			Knop_In
			btfss	Knop			;    -    	
			Goto	Mr				;   -    
			Knop_Out
			Goto	Main_Bykl
;-----------------------------------;
Mr          comf    Reg_1,f			;  
            bsf     Reg_2,4
            bsf		Reg_3,3
            ;-------------;
            decfsz  Reg_1,F
            goto    $-1
            decfsz  Reg_2,F     	; 
            goto    $-3
            btfsc   Knop        	;  
            Goto    Time_real 		;   -   Time_real
            decfsz  Reg_3,F
            goto    $-7
;-----------------------------------;
			Call	OUT_Set			;  Out 
			Goto	MAIN			;   
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH;
;---------------------------------------------------------------------------;
;           
			; 
Time_real	Knop_Out
            movlw   1	    		;  
			call    Load_command	;
  			Call	mS_5
            movlw   0xC0    		;    
			call    Load_command	;
			movlw	Real_T-0x2100	;     EEPROM
			Call	Text_EEPR		;  "  Set Time On   "
			Knop_In
			btfss	Knop
			Goto	$-1
			Knop_Out
Main_Time			
            call    mS_5           
			Call	Ind_Time       
            clrf    D_Minut
    		clrf    Minut
    		bsf		bank_1
    		bsf     RC_Minut
    		bcf     bank_0

N		    btfss   RC_Minut
    		goto    Fin
    		incf    Minut,f        ;
    		movfw   Minut
    		addlw   -.9
    		btfss   _Z      
    		goto    n
    		movfw   D_Minut
    		addlw   -.5
    		btfss   _Z      
    		goto    N
    		goto    Fin
n    		movfw   Minut
    		addlw   -.10
    		btfss   _Z      
    		goto    N
            clrf    Minut
    		incf    D_Minut,f        ;
    		goto    N
    
Fin 	    bsf     bank_1
    		bcf     RC_Minut
    		bcf     bank_0
    		bsf     RC_Minut
;fffffffffffffffffffffffffffffffff;
;sssssssssssssssssssssssssssssssss;
;             
    		clrf    D_Chas
    		clrf    Chas
    		bsf	 	bank_1
    		bsf     RC_Chas
    		bcf     bank_0

N0		    btfss   RC_Chas
    		goto    Fin0
    		incf    Chas,f        ;
    		movfw   Chas
    		addlw   -.3
    		btfss   _Z      
    		goto    n0
    		movfw   D_Chas
    		addlw   -.2
    		btfss   _Z      
    		goto    N0
    		goto    Fin0
n0    		movfw   Chas
    		addlw   -.10
    		btfss   _Z      
    		goto    N0
            clrf    Chas
    		incf    D_Chas,f        ;
    		goto    N0
    
Fin0	    bsf     bank_1
    		bcf     RC_Chas
    		bcf     bank_0
    		bsf     RC_Chas

			Knop_In
            btfsc   Knop
            goto    Sr 
            btfss   Knop 
            goto    $-1 
			Goto	Dr
			;-----------------------;
Sr			Knop_Out
			Goto	Main_Time
			;-----------------------;
Dr			Knop_Out
	        movlw   1	    		;  
			call    Load_command;
  			Call	mS_5      
            Call    Write_Time		;   
			Call	Nadpisi
			bcf		Flag,3	
			Goto	MAIN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;    
Ind_Time
            movlw   0x86            ;     
			call    Load_command

            movfw   D_Chas		;     
            btfss   _Z			;   "0"
            goto    $+4         ; 
            movlw   20h			;   (  )
			call    Load_symbol	;
            goto    M
            movlw   30h
            addwf   D_Chas,w
			call    Load_symbol
M           movlw   30h
            addwf   Chas,w
			call    Load_symbol		;
;-----------------------------------;
;         
			btfss	Flag,3
            Goto	Tochk
            movlw   ':'
			call    Load_symbol
			Goto	TT
Tochk		incf	Tochki,f
            btfsc   Tochki,0   
            movlw   ':'
            btfss   Tochki,0         
            movlw   20h
			call    Load_symbol
;---------------------------------;
TT         	movlw   30h
            addwf   D_Minut,w
			call    Load_symbol
            movlw   30h
            addwf   Minut,w
			call    Load_symbol 
            movlw   ' '
			call    Load_symbol
            movlw   ' '
			call    Load_symbol
            movlw   ' '
			call    Load_symbol
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;     
Ind_Time_Bkl
			btfsc	Flag,3
            movlw   0xc5    		;			
			btfss	Flag,3
            movlw   0xc2    		; 
			call    Load_command
			;-----------------------;
            movfw   N_D_Chas_Bkl	;     
            btfss   _Z				;   "0"
            goto    $+4         	; 
            movlw   20h				;   (  )
			call    Load_symbol		;
            goto    M1
            movlw   30h
            addwf   N_D_Chas_Bkl,w
			call    Load_symbol
M1          movlw   30h
            addwf   N_Chas_Bkl,w
			call    Load_symbol
			;-----------------------; 
            movlw   ':'
			call    Load_symbol
			;-----------------------;
            movlw   30h				;
            addwf   N_D_Min_Bkl,w
			call    Load_symbol
            movlw   30h
            addwf   N_Min_Bkl,w
			call    Load_symbol
			movlw	' '				;   
			call    Load_symbol		;  		 
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
Ind_Time_Bykl
			btfsc	Flag,3
            movlw   0xc5    	;			
			btfss	Flag,3
            movlw   0xcb    	; 
			call    Load_command
            movfw   N_D_Chas_Bykl;     
            btfss   _Z			;   "0"
            goto    $+4         ; 
            movlw   20h			;   (  )
			call    Load_symbol	;
            goto    M2
            movlw   30h
            addwf   N_D_Chas_Bykl,w
			call    Load_symbol
M2          movlw   30h
            addwf   N_Chas_Bykl,w
			call    Load_symbol
;-------------------------------; 
            movlw   ':'
			call    Load_symbol
;-------------------------------;
            movlw   30h
            addwf   N_D_Min_Bykl,w
			call    Load_symbol
            movlw   30h
            addwf   N_Min_Bykl,w
			call    Load_symbol 
                RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;; 
;-------------------------------;
Write_Time
			swapf	D_Minut,w	;      
			iorwf	Minut,f		;   
			swapf	D_Chas,w	;      
			iorwf	Chas,f		;   

W_T        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			call	Start  
			call	TX		    ; 
            btfsc   ACK         ;    1307 
            goto    W_T  		;   - 

        	movlw   0x01		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    W_T		    ;   - 
 
        	movfw	Minut		;    
        	movwf   Reg_TX		;    
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    W_T		    ;   - 

        	movfw	Chas		;     
        	movwf   Reg_TX		;    
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    W_T		    ;   - 
				RETURN
;-------------------------------;
;;
;-------------------------------;
Read_time
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			call	Start  
			call	TX		    ; 
            btfsc   ACK         ;    1307 
            goto    Read_time   ;   - 

        	movlw   0x01		;      
        	movwf   Reg_TX		;     1307
			call	TX		    ;
            btfsc   ACK         ;    1307 
            goto    Read_time   ;   - 

dd			call	Start   	;  
        	movlw   0xD0		;   1307
        	movwf   Reg_TX		;
			bsf		Reg_TX,0	;
			call	TX		    ;
            btfsc   ACK         ;    
            goto    dd          ; 

		    bcf     NACKM  		;   
            call    RX          ;   
            movfw   Reg_RX      ;    
            movwf   R_Min       ;     
 
            bsf     NACKM		;   
            call    RX	  		; 
            movfw   Reg_RX      ;   
            movwf   R_Chas      ;   
			call	Stop	    ;   
;-------------------------------;
Transform
;-------------------------------;
            movfw   R_Sek       ;
            andlw   0fh		    ;           
            movwf   Sekund      ;  
            swapf   R_Sek,w     ;
            andlw   0fh		    ;           
            movwf   D_Sekund    ;  			
            movfw   R_Min       ;
            andlw   0fh		    ;           
            movwf   Minut       ;  
            swapf   R_Min,w     ;
            andlw   0fh		    ;           
            movwf   D_Minut     ;  
            movfw   R_Chas      ;
            andlw   0fh		    ;           
            movwf   Chas        ; 
            swapf   R_Chas,w    ;
            andlw   0fh		    ;           
            movwf   D_Chas      ;  
				RETURN
;-------------------------------;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;      
Sravnenie							;   
            movfw   Minut            
            movwf   temp_Min    	
            movfw   D_Minut
            movwf   temp_D_Min
            movfw   Chas
            movwf   temp_Chas
            movfw   D_Chas
            movwf   temp_D_Chas
			;----------------------;	
            movfw   N_Min_Bkl 	   ;      
            subwf   temp_Min,f     ; .  0-  
 
            movfw   N_D_Min_Bkl    ;  1-  
            btfss   _C 
            incfsz  N_D_Min_Bkl,w 
            subwf   temp_D_Min,f 
 
            movfw   N_Chas_Bkl     ;  2-  
            btfss   _C 
            incfsz  N_Chas_Bkl,w 
            subwf   temp_Chas,f 
 
            movfw   N_D_Chas_Bkl    ;  3-  
            btfss   _C 
            incfsz  N_D_Chas_Bkl,w 
            subwf   temp_D_Chas,f

            btfss   _C              ;    ="0",   
            	RETURN          	;    
;-----------------------------------------------------------------------;
;  ,        
;   
			;  
Vykl    
            movfw   Minut            
            movwf   temp_Min    	;   
            movfw   D_Minut
            movwf   temp_D_Min
            movfw   Chas
            movwf   temp_Chas
            movfw   D_Chas
            movwf   temp_D_Chas
			;-----------------------;
            movfw   N_Min_Bykl      ;     
            subwf   temp_Min,f 		;  .  0-  
 
            movfw   N_D_Min_Bykl	;  1-  
            btfss   _C 
            incfsz  N_D_Min_Bykl,w 
            subwf   temp_D_Min,f 
 
            movfw   N_Chas_Bykl     ;  2-  
            btfss   _C 
            incfsz  N_Chas_Bykl,w 
            subwf   temp_Chas,f 
 
            movfw   N_D_Chas_Bykl   ;  3-  
            btfss   _C 
            incfsz  N_D_Chas_Bykl,w 
            subwf   temp_D_Chas,f
			;-----------------------;
            btfss   _C				;    ="0",       
            Goto	Foto  			;  ,       
            bcf     Svet  			;  ,       
		    	RETURN
;-----------------------------------;
;       .
Foto       
            btfsc   R_Foto          ;  - 
            bcf     Svet            ; - ,
            btfss   R_Foto          ;  -
            bsf     Svet            ; - .
		    	RETURN
;;
;-----------------------------------; 
;;
mS_500
            movlw	.85
            movwf   Reg_1
            movlw   .138
            movwf   Reg_2
            movlw   .3
            movwf   Reg_3

            decfsz  Reg_1,F
            goto    $-1
			;-----------------------;
			bsf		bank_1
			bsf		TRISA,1			;   (Knopka)
			bcf		bank_0
			;-----------------------;
			btfss	Knop
			Goto	Setting
            decfsz  Reg_2,F
            goto    $-8
            decfsz  Reg_3,F
            goto    $-.10
				RETURN
;-------------------------------;
mkS_10		
			movlw   .3
            movwf   Reg_1
            decfsz  Reg_1,F
            goto    $-1
			    RETURN
;-----------------------------------;
;;
Text_EEPR	bsf		bank_1		;  "Setting"
			movwf	EEADR		;     
Cykle_5	   	bsf		bank_1 		;
			bsf     EECON1,0  	;  ( )			
			incf	EEADR,f   	; 
     	    movfw   EEDATA		; .    EEPROM   W.	
    		bcf     bank_0		;
			btfsc	_Z			;     ( )
				RETURN			;
			call    Load_symbol	;>>    
			Goto	Cykle_5		;
;;
;      EEPROM 
;-----------------------------------;
Load_EEPROM
 			bsf		bank_1
            movwf   EEADR       	;   .
 			bcf		bank_0
            movfw   Data_EEPR   	; 
			bsf		bank_1
            movwf   EEDATA      	; 
            bsf     EECON1,2    	;  .                                   
            movlw   055h        	; 
            movwf   EECON2      	; 
            movlw   0AAh        	;  .
            movwf   EECON2      	; ----"----
            bsf     EECON1,1        ; ----"---				   		
L20			btfsc	EECON1, WR		;   
			goto	L20
			bcf		EECON1, WREN	;    EEROM
			bcf     bank_0			; 
				RETURN
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;;
;;
	include		"I2C_connection.asm"
	include		"LCD_connection.asm"
;-----------------------------------------------------------------------;
        	ORG 0x2100
Bkl_Bykl	de  0,0,0,0,0,0,0,0		;  DE
Bkl			de	"  Set Time On",0	; 
Bykl		de	"  Set Time Off",0	; "0" -  
Real_T		de	"  Set Real Time",0	; 
OUT 		de  "      OUT",0
Time		de	"Time",0
On_Off		de	"On      Off",0
Set_		de  "    Setting     ",0
;;
	END
