      list      p=16f876            ; list directive to define processor
      #include <p16f876.inc>
      #include <rus_tab.inc>

;LINE1          EQU  0x080   ; Set display to line 1 character 0
LCD             EQU     PORTB
E               EQU     1
R_W             EQU     2
RS              EQU     3
;DISP_ON         EQU     0x00C   ; Display on
;DISP_ON_C       EQU     0x00E   ; Display on, Cursor on
;DISP_ON_B       EQU     0x00F   ; Display on, Cursor on, Blink cursor
;DISP_OFF        EQU     0x008   ; Display off
;CLR_DISP        EQU     0x001   ; Clear the Display

PortDev         EQU     PORTC
Dev1            EQU     0x05
Dev2            EQU     0x04

                cblock  0x20

			InUse_fl
			tim1_0
			tim1_1
			tim1_2
			tim1_3
			tim1_4
			tim1_5
			tim2_0
			tim2_1
			tim2_2
			tim2_3
			tim2_4
			tim2_5
			pos_t1
			pos_t2
			posb_t1
			posb_t2
			blink
                        count0
                        count1
                        count2
                        Temp
                        Char
			symbol
			t0
                        t1
                        t2
                        t3
			t_prom
                        w_temp
                        status_temp

                endc

        org     0x00
        goto	Begin

        org	0x04            ; 
        movwf	w_temp            ;   W 
        swapf	STATUS,0          ;STATUS
        movwf	status_temp
        
        bcf	STATUS,RP0
	bcf	PIR1,CCP1IF         ; 

	incf	blink,f
	
	btfss	InUse_fl,1
	goto	t_2

	movf	tim1_0,f
	btfsc	STATUS,Z
	goto	t1_n1
	decf	tim1_0,f
	goto	t_2
t1_n1	movlw	.9
	movwf	tim1_0

	movf	tim1_1,f
	btfsc	STATUS,Z
	goto	t1_n2
	decf	tim1_1,f
	goto	t_2
t1_n2	movlw	.9
	movwf	tim1_1

	movf	tim1_2,f
	btfsc	STATUS,Z
	goto	t1_n3
	decf	tim1_2,f
	goto	t_2
t1_n3	movlw	.9
	movwf	tim1_2

	movf	tim1_3,f
	btfsc	STATUS,Z
	goto	t1_n4
	decf	tim1_3,f
	goto	t_2
t1_n4	movlw	.9
	movwf	tim1_3

	movf	tim1_4,f
	btfsc	STATUS,Z
	goto	t1_n5
	decf	tim1_4,f
	goto	t_2
t1_n5	movlw	.9
	movwf	tim1_4

	movf	tim1_5,f
	btfsc	STATUS,Z
	goto	t1_n6
	decf	tim1_5,f
	goto	t_2
t1_n6	movlw	.9
	movwf	tim1_5

	bcf	InUse_fl,1
	bcf	PortDev,Dev1
	clrf	tim1_0
	clrf	tim1_1
	clrf	tim1_2
	clrf	tim1_3
	clrf	tim1_4
	clrf	tim1_5
	movlw	0x22
	movwf	pos_t1
	movlw	b'00000001'
	movwf	posb_t1

;      1
	
t_2	btfss	InUse_fl,2
	goto	t_end

	movf	tim2_0,f
	btfsc	STATUS,Z
	goto	t2_n1
	decf	tim2_0,f
	goto	t_end
t2_n1	movlw	.9
	movwf	tim2_0

	movf	tim2_1,f
	btfsc	STATUS,Z
	goto	t2_n2
	decf	tim2_1,f
	goto	t_end
t2_n2	movlw	.9
	movwf	tim2_1

	movf	tim2_2,f
	btfsc	STATUS,Z
	goto	t2_n3
	decf	tim2_2,f
	goto	t_end
t2_n3	movlw	.9
	movwf	tim2_2

	movf	tim2_3,f
	btfsc	STATUS,Z
	goto	t2_n4
	decf	tim2_3,f
	goto	t_end
t2_n4	movlw	.9
	movwf	tim2_3

	movf	tim2_4,f
	btfsc	STATUS,Z
	goto	t2_n5
	decf	tim2_4,f
	goto	t_end
t2_n5	movlw	.9
	movwf	tim2_4

	movf	tim2_5,f
	btfsc	STATUS,Z
	goto	t2_n6
	decf	tim2_5,f
	goto	t_end
t2_n6	movlw	.9
	movwf	tim2_5

	bcf	InUse_fl,2
	bcf	PortDev,Dev2
	clrf	tim2_0
	clrf	tim2_1
	clrf	tim2_2
	clrf	tim2_3
	clrf	tim2_4
	clrf	tim2_5
	movlw	0x28
	movwf	pos_t2
	movlw	b'00000001'
	movwf	posb_t2
;      2


t_end	swapf	status_temp,0     ;  
        movwf	STATUS            ; W  STATUS
        swapf	w_temp,1          ;
        swapf	w_temp,0          ;
        retfie

Text_Table
        ADDWF PCL,f
        
	
	
	
	
	
	retlw '!'
        RETLW 0

Begin                         ;
        call	Init          ;
        call	Delay_05sec   ;
        call	Init_LCD      ;

        movlw	RTN_HOME       ;return home
        call	Send_Cmd       ;
        movlw	DISP_ON        ; 
        call	Send_Cmd       ; 
GOt     movlw	CLR_DISP       ;  
        call	Send_Cmd       ; 
                                    


;        movlw	LINE1           ;
;        call	Send_Cmd        ;
;        clrf	symbol          ;
;GO1__   movf	symbol,w        ; 
;        call	Text_Table      ;
;        andlw	0FFh            ; 
;        btfsc	STATUS,Z        ;
;        goto	$+4             ; Text_Table
;        call	Send_Char       ;
;        incf	symbol,f        ;
;        goto	GO1__           ;


	movlw	b'00001111'
	movwf	T1CON

        bsf     STATUS,RP0   ;
        movlw   b'00000100'  ; 
        movwf   PIE1          ^80
        bcf     STATUS,RP0   ;
        bcf	PIR1,CCP1IF
	movlw   b'11000000'  ; {Intcon}
        movwf   INTCON

	movlw	.0
	movwf	tim1_0
	movlw	.0
	movwf	tim1_1
	movlw	.0
	movwf	tim1_2
	movlw	.0
	movwf	tim1_3
	movlw	.0
	movwf	tim1_4
	movlw	.0
	movwf	tim1_5

	movlw	.0
	movwf	tim2_0
	movlw	.0
	movwf	tim2_1
	movlw	.0
	movwf	tim2_2
	movlw	.0
	movwf	tim2_3
	movlw	.0
	movwf	tim2_4
	movlw	.0
	movwf	tim2_5

	movlw	0x00
	movwf	InUse_fl

	movlw	0x22
	movwf	pos_t1
	movlw	0x28
	movwf	pos_t2
	movlw	b'00000001'
	movwf	posb_t1
	movlw	b'00000001'
	movwf	posb_t2


	movlw	b'00001011'
	movwf	CCP1CON
	movlw	0xcc
	movwf	CCPR1L
	movlw	0x0c
	movwf	CCPR1H
        
main    
        movlw	LINE1+2           
        call	Send_Cmd        

	movf	tim1_5,w
	addlw	0x30
	btfss	posb_t1,4
	goto	b_t1
	btfsc	blink,2
	goto	b_t1
	movlw	' '
b_t1	call	Send_Char    ;  

	movf	tim1_4,w
	addlw	0x30
	btfss	posb_t1,3
	goto	b_t2
	btfsc	blink,2
	goto	b_t2
	movlw	' '
b_t2	call	Send_Char    ;  

	movf	tim1_3,w
	addlw	0x30
	btfss	posb_t1,2
	goto	b_t3
	btfsc	blink,2
	goto	b_t3
	movlw	' '
b_t3	call	Send_Char    ;  

	movf	tim1_2,w
	addlw	0x30
	btfss	posb_t1,1
	goto	b_t4
	btfsc	blink,2
	goto	b_t4
	movlw	' '
b_t4	call	Send_Char    ;  

	movf	tim1_1,w
	addlw	0x30
	btfss	posb_t1,0
	goto	b_t5
	btfsc	blink,2
	goto	b_t5
	movlw	' '
b_t5	call	Send_Char    ;  

;	movf	tim1_0,w
;	call	print1

        movlw	LINE2+2           
        call	Send_Cmd        

	movf	tim2_5,w
	addlw	0x30
	btfss	posb_t2,4
	goto	b_t21
	btfsc	blink,2
	goto	b_t21
	movlw	' '
b_t21	call	Send_Char    ;  

	movf	tim2_4,w
	addlw	0x30
	btfss	posb_t2,3
	goto	b_t22
	btfsc	blink,2
	goto	b_t22
	movlw	' '
b_t22	call	Send_Char    ;  

	movf	tim2_3,w
	addlw	0x30
	btfss	posb_t2,2
	goto	b_t23
	btfsc	blink,2
	goto	b_t23
	movlw	' '
b_t23	call	Send_Char    ;  

	movf	tim2_2,w
	addlw	0x30
	btfss	posb_t2,1
	goto	b_t24
	btfsc	blink,2
	goto	b_t24
	movlw	' '  
b_t24	call	Send_Char    ;  

	movf	tim2_1,w
	addlw	0x30
	btfss	posb_t2,0
	goto	b_t25
	btfsc	blink,2
	goto	b_t25
	movlw	' '
b_t25	call	Send_Char    ;  

;	movf	tim2_0,w
;	addlw	0x30
;	call	Send_Char    ;  

;	bsf	PORTC,4
	call	del_50ms	        
;	bcf	PORTC,4
;	call	Delay_05sec	        


Klava
	movlw	b'00110000'
	movwf	PORTA
	btfss	PORTA,0
	goto	_kn1
	btfss	PORTA,1
	goto	_kn2
	btfss	PORTA,2
	goto	_kn3
	movlw	b'00101000'
	movwf	PORTA
	btfss	PORTA,0
	goto	_kn4
	btfss	PORTA,1
	goto	_kn5
	btfss	PORTA,2
	goto	_kn6
	movlw	b'00011000'
	movwf	PORTA
	btfss	PORTA,0
	goto	_kn7
	btfss	PORTA,1
	goto	_kn8
	btfss	PORTA,2
	goto	_kn9

	bsf	InUse_fl,0

	goto	main

_kn1                         ; Start/Stop t1
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0
	btfsc	InUse_fl,1
	goto	stop_t1
	bsf	InUse_fl,1
	bsf	PortDev,Dev1
	movlw	b'10000000'
	movwf	posb_t1
	movlw	.0
	movwf	tim1_0
	goto	Klava
stop_t1
	bcf	InUse_fl,1
	bcf	PortDev,Dev1
	movlw	0x22
	movwf	pos_t1
	movlw	b'00000001'
	movwf	posb_t1
	goto	Klava

_kn2
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0
	btfsc	InUse_fl,1
	goto	stop_t12
	bsf	InUse_fl,1
	bsf	PortDev,Dev1
	bsf	InUse_fl,2
	bsf	PortDev,Dev2
	movlw	b'10000000'
	movwf	posb_t1
	movwf	posb_t2
	movlw	.0
	movwf	tim1_0
	movwf	tim2_0
	goto	Klava
stop_t12
	bcf	InUse_fl,1
	bcf	PortDev,Dev1
	bcf	InUse_fl,2
	bcf	PortDev,Dev2
	movlw	0x22
	movwf	pos_t1
	movlw	0x28
	movwf	pos_t2
	movlw	b'00000001'
	movwf	posb_t1
	movwf	posb_t2
	goto	Klava


_kn3                         ; Start/Stop t2
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0
	btfsc	InUse_fl,2
	goto	stop_t2
	bsf	InUse_fl,2
	bsf	PortDev,Dev2
	movlw	b'10000000'
	movwf	posb_t2
	movlw	.0
	movwf	tim2_0
	goto	Klava
stop_t2
	bcf	InUse_fl,2
	bcf	PortDev,Dev2
	movlw	0x28
	movwf	pos_t2
	movlw	b'00000001'
	movwf	posb_t2
	goto	Klava

_kn4
	btfsc	InUse_fl,1
	goto	Klava
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0

	btfsc	posb_t1,4
	goto	rolup

	bcf	STATUS,C
	rlf	posb_t1,f
	incf	pos_t1,f
	goto	Klava
rolup
	movlw	0x22
	movwf	pos_t1
	movlw	b'00000001'
	movwf	posb_t1
	goto	Klava


_kn5
        movlw	LINE1           
        call	Send_Cmd        
	movlw	0x05
	addlw	0x30
	call	Send_Char    ;  
	goto	Klava

_kn6                         ;mov cursor
	btfsc	InUse_fl,2
	goto	Klava
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0

	btfsc	posb_t2,4
	goto	rolup2

	bcf	STATUS,C
	rlf	posb_t2,f
	incf	pos_t2,f
	goto	Klava
rolup2
	movlw	0x28
	movwf	pos_t2
	movlw	b'00000001'
	movwf	posb_t2
	goto	Klava

_kn7                         ; 
	btfsc	InUse_fl,1
	goto	Klava
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0
	
	movf	pos_t1,w
	movwf	FSR
	movlw	.9
	subwf	INDF,w
	btfsc	STATUS,Z
	goto	in1
	incf	INDF,f
	goto	Klava
in1
	clrf	INDF
	goto	Klava

_kn8
        movlw	LINE1           
        call	Send_Cmd        
	movlw	0x08
	addlw	0x30
	call	Send_Char    ;  
	goto	Klava

_kn9                         ; 
	btfsc	InUse_fl,2
	goto	Klava
	call	del_50ms	        
	btfss	InUse_fl,0
	goto	Klava
	bcf	InUse_fl,0

	movf	pos_t2,w
	movwf	FSR
	movlw	.9
	subwf	INDF,w
	btfsc	STATUS,Z
	goto	in2
	incf	INDF,f
	goto	Klava
in2
	clrf	INDF
	goto	Klava

;-------------------------------------------------------
;     

Init        ;  
        clrf    PORTA        ;\
        clrf    PORTB        ; |
        clrf    PORTC        ; |
        bsf     STATUS,RP0   ; | 
        movlw   b'00000111'  ; | 
        movwf   PORTA        ; |
        movlw   b'00000000'  ; |
        movwf   PORTB        ; |
        movlw   b'00000000'  ; |
        movwf   PORTC        ;/

        movlw   b'00000110'      ;    
        movwf   ADCON1      ^80  ;       A/D
        clrwdt               ;
        movlw   b'10000011'  ; {Option}
        movwf   01h   ;
        nop
        bcf     STATUS,RP0   ;    0
        movlw   b'00000000'  ; {Intcon}
        movwf   INTCON
;
        return

Init_LCD
        movlw DISP_OFF
        call Send_Cmd
        clrf LCD
        bsf LCD,5  ;
        bsf LCD,E
        nop          ;
        bcf LCD,E
        call del_50us
        bsf LCD,E
        nop          ;
        bcf LCD,E
        call del_50us
        bcf LCD,5
        nop ; bsf LCD,6 ;(7)
        bsf LCD,E
        nop          ;
        bcf LCD,E
        call del_50us
        movlw b'00101000'       ; 58  1 
        call Send_Cmd
        movlw DISP_OFF
        call Send_Cmd
        movlw CLR_DISP
        call Send_Cmd
        clrf	LCD

        return

Send_Cmd
        movwf Char
        call Wait_Busy          ; Wait for LCD to be ready
;	call	del_50ms
        movlw 0x0f
        andwf LCD,f
        movf Char,w
        andlw 0xF0              ; Get upper nibble
        iorwf LCD,f             ; Send data to LCD
        bcf LCD,R_W             ; Set LCD to write
        bcf LCD,RS              ; Set LCD to command mode
        bsf LCD,E
        nop          ;
        bcf LCD,E
        movlw 0x0f
        andwf LCD,f             ; Clear the upper nibble
        swapf Char,w
        andlw 0xF0              ; Get lower nibble
        iorwf LCD,f             ; Send data to LCD
        bsf LCD,E
        nop          ;
        bcf LCD,E
;        clrf	LCD

        return

Send_Char
        movwf Char
        call Wait_Busy          ; Wait for LCD to be ready
;	call	del_50ms
        movlw 0x0f
        andwf LCD,f
        movf Char,w
        andlw 0xF0              ; Get upper nibble
        iorwf LCD,f             ; Send data to LCD
	bcf LCD,R_W             ; Set LCD to write
        bsf LCD,RS              ; Set LCD to data mode
        bsf LCD,E
        nop          ;
        bcf LCD,E
        movlw 0x0f
        andwf LCD,f             ; Clear the upper nibble
        swapf Char,w
        andlw 0xF0              ; Get lower nibble
        iorwf LCD,f             ; Send data to LCD
        bsf LCD,E
        nop          ;
        bcf LCD,E
;        clrf	LCD

        return

Wait_Busy
        bcf	INTCON,7
        bsf	STATUS,RP0
        movlw	0xf0              ; Set line to input
        iorwf	TRISB^80,W           ; Only set upper half of port
        movwf	TRISB^80
        bcf	STATUS,RP0
        bsf	INTCON,7
Wait_B  bcf	LCD,RS              ; Set LCD for Command mode
        bsf	LCD,R_W             ; Setup to read busy flag
        bsf	LCD,E               ; Set E high
        movf	LCD,W              ; Read upper nibble busy flag, DDRam address
        bcf	LCD,E               ; Set E low
        andlw   0xF0            ; Mask out lower nibble
        movwf   Temp
        bsf	LCD,E               ; Toggle E to get lower nibble
        swapf	LCD,w     ; Read lower nibble busy flag, DDRam address
        bcf	LCD,E
        andlw	0x0F              ; Mask out upper nibble
        iorwf	Temp,f            ; Combine nibbles, RES in Temp
        btfsc	Temp,7            ; Check busy flag, high = busy
        goto	Wait_B             ; If busy, check again
        bcf	LCD,R_W
        bcf	INTCON,7
        bsf	STATUS,RP0
        movlw	0x0F
        andwf	TRISB^80,W
        movwf	TRISB^80             ; Set Port for output
        bcf	STATUS,RP0
        bsf	INTCON,7
;        clrf	LCD

        return

Delay_1sec
        movlw .20
        movwf count2
        call del_50ms
        decfsz count2,f
        goto $-2
        return

Delay_05sec
        movlw .10
        movwf count2
        call del_50ms
        decfsz count2,f
        goto $-2
        return

del_50ms
        movlw .66
        movwf count1
        decfsz count0,f
        goto $-1
        decfsz count1,f
        goto $-3
        return

del_50us
        movlw .17
        movwf count2
        decfsz count2,f
        goto $-1
        return

;*********************************************************************
;              8 Bit binary ---> 3  BCD Number.
;*********************************************************************
;  (W- t_prom- )     
; t0- t1 - , t2 - , t3 - , W -  
conv_num
	clrf	t0	; 
        clrf	t1	; 
        clrf	t2	; 
        movwf	t3	; 
ghun    movlw	.100
        subwf	t3,w
        btfss	STATUS,C  ;
        goto	gten
        movwf	t3        ;   t2
        incf	t1,f       ; 
        goto	ghun
gten    movf	t_prom,f
	btfsc	STATUS,Z
	goto	gten_2
	decf	t_prom,f
	addlw	0xff
        movwf	t3        ;   t2
        incf	t1,f       ; 
        incf	t3,f     
	goto	ghun
gten_2	movlw	.10
        subwf	t3,w
        btfss	STATUS,C  ;
        goto	over
        movwf	t3        ;   t3
        incf	t2,f       ; 
        goto	gten_2
over	movlw	.10
        subwf	t1,w
        btfss	STATUS,C  ;
        goto	over_2
        movwf	t1        ;   t1
        incf	t0,f      ; 
	goto	over
over_2	return


 End
