        LIST
; LCD Module commands
        NOLIST

; LCD Module commands
; ===================
LINE1          EQU  0x080   ; Set display to line 1 character 0
LINE2          EQU  0x0C0   ; Set display to line 2 character 0

FUNCTION_SET   EQU  0x028   ; 4 bits, 2 lines, 5x7 Font 

;CLR_DISP - clears all display, and cursor home to addr 0
CLR_DISP       EQU  0x001   ; Clear the Display

;RTN_HOME - cursor home and display unshifted, DDRAM unchanged
RTN_HOME    EQU    0X002

;DISP_... - Display on / off control, C = cursor ON, B = chr pos blink
DISP_ON        EQU  0x00C   ; Display on
DISP_ON_C      EQU  0x00E   ; Display on, Cursor on
DISP_ON_B      EQU  0x00F   ; Display on, Cursor on, Blink cursor
DISP_OFF       EQU  0x008   ; Display off

;ENTRY_... - sets entry mode, S = display shift on, INC / DEC cursor move dir
ENTRY_INC      EQU  0x006   ;
ENTRY_INC_S    EQU  0x007   ;
ENTRY_DEC      EQU  0x004   ;
ENTRY_DEC_S    EQU  0x005   ;

;SHIFT_. - Cursor & Display shift, S = Display, C = cursor, L = Left, R = Right
SHIFT_C_L     EQU  0x010
SHIFT_C_R     EQU  0x014
SHIFT_S_L     EQU  0x018
SHIFT_S_R     EQU  0x01C

DD_RAM_ADDR    EQU  0x080   ; Least Significant 7-bit are for address
DD_RAM_UL      EQU  0x080   ; Upper Left coner of the Display

#define 	retlw 'a'	; 쪨
#define 	retlw 0b2h
#define 	retlw 0b3h
#define 	retlw 0b4h
#define 	retlw 0e3h
#define 	retlw 065h
#define 	retlw 0b5h
#define 	retlw 0b6h
#define 	retlw 0b7h
#define 	retlw 0b8h
#define 	retlw 0b9h
#define 	retlw 0bah
#define 	retlw 0bbh
#define 	retlw 0bch
#define 	retlw 0bdh
#define 	retlw 06fh
#define 	retlw 0beh
#define 	retlw 070h
#define 	retlw 063h
#define 	retlw 0bfh
#define 	retlw 079h
#define 	retlw 0e4h
#define 	retlw 078h
#define 	retlw 0e5h
#define 	retlw 0c0h
#define 	retlw 0c1h
#define 	retlw 0e6h
#define 	retlw 0c2h
#define 	retlw 0c3h
#define 	retlw 0c4h
#define 	retlw 0c5h
#define 	retlw 0c6h
;#define 	retlw 0c7h

#define _	retlw 020h

#define 	retlw 'A'	;  
#define 	retlw 0A0H
#define 	retlw 'B'
#define 	retlw 0A1H
#define 	retlw 0E0H
#define 	retlw 'E'
#define 	retlw 0A2H
#define 	retlw 0A3H
#define 	retlw 0A4H
#define 	retlw 0A5H
#define 	retlw 0A6H
#define 	retlw 'K'
#define 	retlw 0A7H
#define 	retlw 'M'
#define 	retlw 'H'
#define 	retlw 'O'
#define 	retlw 0A8H
#define 	retlw 'P'
#define 	retlw 'C'
#define 	retlw 'T'
#define 	retlw 0A9H
#define 	retlw 0AAH
#define 	retlw 'X'
#define 	retlw 0E1H
#define 	retlw 0ABH
#define 	retlw 0ACH
#define 	retlw 0E2H
#define 	retlw 0ADH
#define 	retlw 0AEH
#define 	retlw 'b'
#define 	retlw 0AFH
#define 	retlw 0B0H
#define 	retlw 0B1H

        LIST
